/*
 * Decompiled with CFR 0.152.
 */
package ar.com.imprenta_azul.barras;

import ar.com.imprenta_azul.barras.Barras;
import ar.com.imprenta_azul.barras.CUIT;
import ar.com.imprenta_azul.barras.PanelDeResultado;
import ar.com.imprenta_azul.barras.TipoComprobante;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Ventana
extends JFrame {
    Barras barras = new Barras();
    private PanelDeResultado resultado;

    Ventana() {
        super("Generador de C\u00f3digo de Barras");
        Container cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 3));
        Box b = new Box(2);
        JComponent panelFormulario = this.damePanelFormulario();
        panelFormulario.setMaximumSize(panelFormulario.getMinimumSize());
        b.add(panelFormulario);
        try {
            b.add(new JComponent(){
                Image logo = ImageIO.read(Ventana.class.getResourceAsStream("azul.png"));
                static final int margen = 50;
                {
                    this.setMinimumSize(new Dimension(100, 50));
                    this.setPreferredSize(new Dimension(100, 50));
                    this.setMaximumSize(new Dimension(this.logo.getWidth(null), this.logo.getHeight(null)));
                }

                @Override
                public void paint(Graphics gg) {
                    super.paint(gg);
                    Graphics2D g = (Graphics2D)gg;
                    float prop = this.logo.getWidth(null) / this.logo.getHeight(null);
                    int anchoComponente = this.getWidth();
                    int altoComponente = this.getHeight();
                    int w = anchoComponente - 50;
                    int h = (int)((float)w / prop);
                    if (h > altoComponente - 50) {
                        h = altoComponente - 50;
                        w = (int)((float)h * prop);
                    }
                    int x = (anchoComponente - w) / 2;
                    int y = (altoComponente - h) / 2;
                    g.drawImage(this.logo, x, y, w, h, null);
                }
            });
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        b.setAlignmentX(0.0f);
        cp.add(b);
        JComponent panelResultado = this.damePanelResultado();
        panelResultado.setAlignmentX(0.0f);
        cp.add(panelResultado);
        JLabel label = new JLabel(" \u00a9 2004 Imprenta Azul");
        label.setEnabled(false);
        label.setAlignmentX(0.0f);
        cp.add(label);
        try {
            Image icono = this.getToolkit().createImage(Ventana.class.getResource("barras.png"));
            this.setIconImage(icono);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.pack();
        this.setLocationByPlatform(true);
    }

    private JComponent damePanelResultado() {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.setBorder(BorderFactory.createTitledBorder("Resultado"));
        this.resultado = new PanelDeResultado(this.barras);
        JScrollPane sp = new JScrollPane(this.resultado);
        p.add((Component)sp, "Center");
        JToolBar botonera = new JToolBar();
        botonera.setFloatable(false);
        this.agregarAccion(botonera, this.resultado.accionCopiar);
        this.agregarAccion(botonera, this.resultado.accionGrabar);
        botonera.add(Box.createGlue());
        JButton info = new JButton(new ImageIcon(Ventana.class.getResource("About24.gif")));
        info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Ventana.this, "<html>Hecho por <b>Nicol\u00e1s Lichtmaier</b> en diciembre de 2004.</html>", "Acerca...", 1);
            }
        });
        botonera.add(info);
        p.add((Component)botonera, "First");
        return p;
    }

    private void agregarAccion(JToolBar botonera, Action accion) {
        JButton b = new JButton(accion);
        b.setToolTipText((String)accion.getValue("LongDescription"));
        b.setText(null);
        botonera.add(b);
    }

    private JComponent damePanelFormulario() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Datos del comprobante"));
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int y = 0;
        JLabel label = new JLabel("C.U.I.T.");
        label.setDisplayedMnemonic('C');
        final JTextField campoCuit = new JTextField(13);
        this.campoRestringido(campoCuit, "0123456789-");
        campoCuit.setMinimumSize(campoCuit.getPreferredSize());
        final Color cb = campoCuit.getForeground();
        campoCuit.setForeground(Color.RED);
        this.agregarCampo(p, c, y++, label, campoCuit);
        campoCuit.getDocument().addDocumentListener(new DocumentListener(){

            private void cambio() {
                block2: {
                    try {
                        Ventana.this.barras.setCUIT(new CUIT(campoCuit.getText()));
                        campoCuit.setForeground(cb);
                    }
                    catch (RuntimeException e) {
                        campoCuit.setForeground(Color.RED);
                        if (Ventana.this.barras.getCUIT() == null) break block2;
                        Ventana.this.barras.setCUIT(null);
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.cambio();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.cambio();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.cambio();
            }
        });
        label = new JLabel("Tipo de comprobante");
        label.setDisplayedMnemonic('T');
        DefaultComboBoxModel<TipoComprobante> tcm = new DefaultComboBoxModel<TipoComprobante>(TipoComprobante.values());
        JComboBox<TipoComprobante> lista = new JComboBox<TipoComprobante>(tcm);
        this.agregarCampo(p, c, y++, label, lista);
        lista.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TipoComprobante t = (TipoComprobante)((Object)e.getItemSelectable().getSelectedObjects()[0]);
                Ventana.this.barras.setTipoComprobante(t);
            }
        });
        this.barras.setTipoComprobante((TipoComprobante)((Object)lista.getSelectedItem()));
        label = new JLabel("Punto de venta");
        label.setDisplayedMnemonic('P');
        SpinnerNumberModel pvm = new SpinnerNumberModel(1, 1, 9999, 1);
        pvm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Ventana.this.barras.setPuntoDeVenta(((Number)((SpinnerModel)e.getSource()).getValue()).intValue());
            }
        });
        JSpinner pv = new JSpinner(pvm);
        this.agregarCampo(p, c, y++, label, pv);
        this.barras.setPuntoDeVenta(1);
        label = new JLabel("C.A.I.");
        label.setDisplayedMnemonic('A');
        final JTextField campoCAI = new JTextField(14);
        this.campoRestringido(campoCAI, "0123456789");
        campoCAI.setMinimumSize(campoCAI.getPreferredSize());
        campoCAI.getDocument().addDocumentListener(new DocumentListener(){

            private void cambio() {
                try {
                    Ventana.this.barras.setCAI(Long.parseLong(campoCAI.getText()));
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.cambio();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.cambio();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.cambio();
            }
        });
        this.agregarCampo(p, c, y++, label, campoCAI);
        label = new JLabel("Fecha de vto.");
        label.setDisplayedMnemonic('v');
        Date hoy = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, 15);
        GregorianCalendar calFut = new GregorianCalendar();
        ((Calendar)calFut).add(1, 5);
        SpinnerDateModel fvm = new SpinnerDateModel(cal.getTime(), hoy, calFut.getTime(), 5);
        this.barras.setVencimiento(cal.getTime());
        fvm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Ventana.this.barras.setVencimiento((Date)((SpinnerModel)e.getSource()).getValue());
            }
        });
        JSpinner sp = new JSpinner(fvm);
        SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateInstance(3);
        sp.setEditor(new JSpinner.DateEditor(sp, df.toPattern()));
        this.agregarCampo(p, c, y++, label, sp);
        return p;
    }

    private void campoRestringido(final JTextField campo, final String sePuede) {
        campo.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if (campo.getText().length() >= campo.getColumns() && campo.getSelectedText() == null || sePuede.indexOf(ch) == -1 && !Character.isISOControl(ch)) {
                    e.consume();
                    Ventana.this.getToolkit().beep();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void agregarCampo(JPanel p, GridBagConstraints c, int y, JLabel label, JComponent campo) {
        c.insets = new Insets(2, 2, 2, 2);
        label.setLabelFor(campo);
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = y;
        c.fill = 0;
        c.weightx = 0.0;
        p.add((Component)label, c);
        c.gridx = 1;
        c.gridy = y;
        c.fill = 0;
        c.weightx = 1.0;
        p.add((Component)campo, c);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Ventana v = new Ventana();
        v.setVisible(true);
        v.setDefaultCloseOperation(3);
    }
}

