/*
 * Decompiled with CFR 0.152.
 */
package ar.com.imprenta_azul.barras;

import ar.com.imprenta_azul.barras.AccionCopiar;
import ar.com.imprenta_azul.barras.AccionGrabar;
import ar.com.imprenta_azul.barras.Barras;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.filechooser.FileFilter;

final class PanelDeResultado
extends JPanel
implements ClipboardOwner,
PropertyChangeListener {
    private final Barras barras;
    final AccionCopiar accionCopiar;
    final AccionGrabar accionGrabar;

    public PanelDeResultado(Barras b) {
        this.barras = b;
        this.setMinimumSize(new Dimension(605, 100));
        this.setToolTipText("Arrastre desde aqu\u00ed");
        this.accionCopiar = new AccionCopiar(this);
        this.accionGrabar = new AccionGrabar(this);
        this.accionCopiar.setEnabled(false);
        this.accionGrabar.setEnabled(false);
        DragSource ds = DragSource.getDefaultDragSource();
        ds.createDefaultDragGestureRecognizer(this, 1, new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                dge.startDrag(null, (Transferable)PanelDeResultado.this.barras.clone());
            }
        });
        this.barras.addPropertyChangeListener(this);
        this.setBackground(Color.WHITE);
        this.setSize(605, 100);
        this.setPreferredSize(new Dimension(605, 100));
        this.setOpaque(false);
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(this.accionCopiar));
        menu.add(new JMenuItem(this.accionGrabar));
        this.setComponentPopupMenu(menu);
    }

    public void grabar() {
        try {
            JFileChooser fc = new JFileChooser();
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().endsWith(".png");
                }

                @Override
                public String getDescription() {
                    return "Im\u00e1genes PNG";
                }
            });
            int r = fc.showSaveDialog(this);
            if (r != 0) {
                return;
            }
            File archivo = fc.getSelectedFile();
            if (archivo.exists() && (r = JOptionPane.showConfirmDialog(this, "\u00bfSobreescribir " + archivo + '?')) != 0) {
                return;
            }
            this.writeImageTo(new FileOutputStream(archivo));
        }
        catch (AccessControlException e) {
            this.grabarWebStart();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error grabando imagen", 0);
            e.printStackTrace();
        }
    }

    private void grabarWebStart() {
        try {
            Object fss = this.getWebStartService("javax.jnlp.FileSaveService");
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = loader.loadClass("javax.jnlp.FileSaveService");
            String[] exts = new String[]{"png"};
            Method saveFileDialog = cl.getMethod("saveFileDialog", String.class, exts.getClass(), InputStream.class, String.class);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeImageTo(baos);
            saveFileDialog.invoke(fss, null, exts, new ByteArrayInputStream(baos.toByteArray()), "barras");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error grabando imagen", 0);
            e.printStackTrace();
        }
    }

    private void writeImageTo(OutputStream output) throws IOException {
        Iterator<ImageWriter> it = ImageIO.getImageWritersByMIMEType("image/png");
        IIOImage iio = new IIOImage(this.barras.dameImagen(), null, null);
        ImageWriter w = it.next();
        ImageOutputStream out = ImageIO.createImageOutputStream(output);
        w.setOutput(out);
        w.write(iio);
        out.close();
    }

    public void copiar() {
        Transferable t = (Transferable)this.barras.clone();
        try {
            this.getToolkit().getSystemClipboard().setContents(t, this);
        }
        catch (AccessControlException e) {
            try {
                Object cs = this.getWebStartService("javax.jnlp.ClipboardService");
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> csClass = loader.loadClass("javax.jnlp.ClipboardService");
                Method setContent = csClass.getMethod("setContents", Transferable.class);
                setContent.invoke(cs, t);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                JOptionPane.showMessageDialog(this, e2, "Error copiando al clipboard", 0);
            }
        }
    }

    private Object getWebStartService(String className) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> sm = loader.loadClass("javax.jnlp.ServiceManager");
        Method lookup = sm.getMethod("lookup", String.class);
        return lookup.invoke(null, className);
    }

    @Override
    protected void paintComponent(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        AffineTransform transform = g.getTransform();
        this.barras.pintar(g);
        g.setTransform(transform);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.barras) {
            boolean valido = this.barras.valido();
            this.accionCopiar.setEnabled(valido);
            this.accionGrabar.setEnabled(valido);
            this.repaint();
        }
    }
}

