/*
 * Decompiled with CFR 0.152.
 */
package ar.com.imprenta_azul.barras;

import java.io.Serializable;

public class CUIT
implements Serializable,
Cloneable,
Comparable<CUIT> {
    private static final long serialVersionUID = 1L;
    private final String cuit;
    private static final int[] refvector = new int[]{5, 4, 3, 2, 7, 6, 5, 4, 3, 2, 1};

    public CUIT(CharSequence c) {
        this.cuit = CUIT.sacaGuiones(c);
        if (this.cuit.length() != 11) {
            throw new ExcepcionCUITInvalido("El C.U.I.T. " + c + " tiene longitud inv\u00e1lida.");
        }
        try {
            if (Long.parseLong(this.cuit) <= 20000000000L) {
                throw new ExcepcionCUITInvalido("El C.U.I.T. " + c + " es un n\u00famero incorrecto.");
            }
        }
        catch (NumberFormatException e) {
            throw new ExcepcionCUITInvalido("El C.U.I.T. " + c + " no es num\u00e9rico.");
        }
        int suma = 0;
        int i = 0;
        while (i < 11) {
            suma += (this.cuit.charAt(i) - 48) * refvector[i];
            ++i;
        }
        if (suma % 11 != 0) {
            throw new ExcepcionCUITInvalido("El C.U.I.T. " + c + " es inv\u00e1lido");
        }
    }

    public String toString() {
        return this.formateaCUIT();
    }

    public String sinGuiones() {
        return this.cuit;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CUIT)) {
            return false;
        }
        return this.cuit.equals(((CUIT)o).cuit);
    }

    public int hashCode() {
        return this.cuit.hashCode();
    }

    @Override
    public int compareTo(CUIT o) {
        return this.cuit.compareTo(o.cuit);
    }

    private static final String sacaGuiones(CharSequence s) {
        int largo = s.length();
        StringBuilder r = new StringBuilder(largo);
        int i = 0;
        while (i < largo) {
            char ch = s.charAt(i);
            if (ch != '-' && !Character.isSpaceChar(ch)) {
                r.append(ch);
            }
            ++i;
        }
        return r.toString();
    }

    private String formateaCUIT() {
        if (this.cuit.indexOf(45) != -1) {
            return this.cuit;
        }
        int largo = this.cuit.length();
        return String.valueOf(this.cuit.substring(0, 2)) + '-' + this.cuit.substring(2, largo - 1) + '-' + this.cuit.substring(largo - 1);
    }

    public static class ExcepcionCUITInvalido
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        ExcepcionCUITInvalido(String m) {
            super(m);
        }
    }
}

